!
    PROGRAM Fleygbogi
!-----------------------------------------------
!
!   Forrit til að heilda hreyfijöfnu kasthreyfingar
!   með loftmótstöðu í tíma. Neðst er hægt að velja
!   tegund líkans fyrir loftmótstöðu.
!

    USE Mod_Precision        ! tvöföld nákvæmni raun- og þvertalna
   
    IMPLICIT NONE            ! Allar breytur þarf að tiltaka

    REAL(KIND=dp)  ::  EPS, T, TOUT, dT, k, v0, Theta
    INTEGER        ::  i, IERFLG, MSTATE
    
   
    REAL(KIND=dp), PARAMETER    :: g = 9.82_dp                   ! Þyngdarhröðun (m/s**2)
    REAL(KIND=dp), PARAMETER    :: pi = 3.14159265358979324_dp
    INTEGER,       PARAMETER    :: N = 4                         ! N er fjöldi jafna
    INTEGER,       PARAMETER    :: LENW = N*N + 11*N + 300
   
   
    REAL(KIND=dp),  DIMENSION(LENW) ::  WORK       ! Hjálparvigur fyrir DDRIV1 
    REAL(KIND=dp),  DIMENSION(N+2)  ::  Y          ! Lausn
     
    REAL(KIND=dp),  EXTERNAL  :: F                 ! Undirstefja fyrir afleiðujöfnuhneppið 
    
    OPEN(UNIT=12,FILE='YTout.dtx',STATUS='NEW')    ! Nafn útskrár, (ekki er hægt að skrifa ofan i hana)
                
    T  = 0.000010_dp    ! Upphafspunktur í tíma
    dT = 0.001_dp       ! Tímabil
!   k  = 0.1_dp         ! Viðnámsstuðull (1/s)
                       
!   Y(1) =  1.0_dp      
!   Y(2) =  0.0_dp

    READ(5,*) v0, Theta, k  ! Upphafshraði (m/s), horn (radíanar), viðnámstuðull (1/s)
    
    Y(1) =  0.0_dp          ! upphaf x(0)
    Y(3) =  0.0_dp          ! upphaf y(0)
    
    Y(2) =  v0*COS(Theta)   ! upphaf vx(0)
    Y(4) =  v0*SIN(Theta)   ! upphaf vy(0)
                    
    Y(N+1) = k         ! Stikar sendir í fall F
    Y(N+2) = g         ! -"- 
    TOUT = T           ! Tími
    MSTATE = 1         ! Stýring á heildun, sjá ddriv1.f
    EPS = .0010_dp     ! Afstæð nákvæmni, sjá ddriv1.f
    
    DO WHILE (TOUT .LT. 30.0_dp)
      CALL DDRIV1 (N, T, Y, F, TOUT, MSTATE, EPS, WORK, LENW, IERFLG)
      IF(MSTATE .GT. 2) STOP 
      WRITE(12,FMT='(100(E17.8,1X))') TOUT, (Y(i), i=1,N)
      TOUT = TOUT+dT
    END DO
    
    END PROGRAM Fleygbogi

    SUBROUTINE F (N, T, Y, YDOT)  ! Undirstefja sem gefur afleiðujöfnuhneppið
!
    USE Mod_Precision

    REAL(KIND=dp)  :: k, T, g
    REAL(KIND=dp), DIMENSION(*)  :: Y, YDOT

    k = Y(N+1)
    g = Y(N+2)

!    YDOT(1) =    Y(2)           !  Viðnám línulegt með hraða
!    YDOT(2) = -k*Y(2)           !
!    YDOT(3) =    Y(4)           !
!    YDOT(4) = -k*Y(4)-g         !

    YDOT(1) =    Y(2)                     ! Viðnám í réttu hlutfalli við hraða í öðru veldi
    YDOT(2) = -k*SIGN(Y(2)**2,Y(2))       ! Takið eftir SIGN-fallinu til að hafa rétt formerki
    YDOT(3) =    Y(4)                     !
    YDOT(4) = -k*SIGN(Y(4)**2,Y(4))-g     !
!
    END SUBROUTINE F
