 
    PROGRAM RangeImplicit
!-----------------------------------------------
!   Óbein jafna leyst, jafna (2.45) í bók
!   óbeina jafnan er gefin með Fallinu: "Fall".

    USE Mod_Precision        ! tvöföld nákvæmni raun- og þvertalna
    USE Mod_BreyturRange
   
    IMPLICIT NONE            ! Allar breytur þarf að tiltaka

    INTEGER       :: i, IFLAG2
    REAL(KIND=dp) :: EPS, RE, AE, kdel, v0, x, R, kT, KTr 

    REAL(KIND=dp), EXTERNAL :: Fall

    OPEN(UNIT=12,FILE='Range.dtx',STATUS='NEW')

    v0    = 20.0_dp          ! Upphafshraði
    Theta = 1.0_dp           ! Upphafshorn í radíönum
    V     = v0*SIN(Theta)    ! y-þáttur upphafshraða
    U     = v0*COS(Theta)


    EPS = 0.00000001_dp 


    kdel = 0.4_dp/REAL(N,dp)
    k    = 0.001
    DO i = 1, N
      k  = k + kdel
      B = 0.0001_dp            ! Upphaf bils
      C = 16.0_dp              ! Endir bils 
      RE  = EPS
      AE  = EPS
      R   = (B+C)*0.5_dp
      IFLAG2  = 0
      CALL DFZERO(Fall, B, C, R, RE, AE, IFLAG2)   
      kTr = 0.5_dp*(B+C)
      x   = (U/k)*(1.0_dp-EXP(-kTr))
      WRITE(12,FMT='(2(E17.8,1X),I4)') k, x, IFLAG2
    END DO

!-------------------------------------------------
    END PROGRAM RangeImplicit

  FUNCTION Fall(kT)

    USE Mod_Precision
    USE Mod_BreyturRange

    IMPLICIT NONE
    REAL(KIND=dp) :: kT, Fall

    Fall = ((k*V)/g+1.0_dp)*(1.0_dp-EXP(-kT))-kT
    
 !   WRITE(6,FMT='(5(E14.5,1X))') kT, g, V, k, Fall
!--------------------------------------------------
  END FUNCTION Fall