!
    PROGRAM Sveifill
!-----------------------------------------------
!   Forrit til að heilda tölulega hreyfijöfnu sveifils.
!   Hann getur verið línulegur eða ólínulegur
!

    USE Mod_Precision
   
    IMPLICIT NONE

    REAL(KIND=dp)  ::  EPS, T, TOUT, dT 
    INTEGER        ::  i, IERFLG, MSTATE
    
   
    REAL(KIND=dp), PARAMETER    :: ALFA = 0.1_dp
    REAL(KIND=dp), PARAMETER    :: pi = 3.14159265358979324_dp
    INTEGER,       PARAMETER    :: N = 2          ! N fjöldi jafna
    INTEGER,       PARAMETER    :: LENW = N*N + 11*N + 300
   
   
    REAL(KIND=dp),  DIMENSION(LENW) ::   WORK
    REAL(KIND=dp),  DIMENSION(N+1)  ::   Y
    
    REAL(KIND=dp), EXTERNAL  :: F
    
    OPEN(UNIT=12,FILE='YTout.dtx',STATUS='NEW')
                
    T  = 0.000010_dp     ! Upphafspunktur í tíma
    dT = 0.001_dp
                       
!   Y(1) =  1.0_dp       ! Upphafsskilyrði
!   Y(2) =  0.0_dp

    READ(5,*) Y(1), Y(2)
                    
    Y(N+1) = ALFA        ! Dofnunarstiki: ALPHA = 2*beta in book, 

    TOUT = T
    MSTATE = 1
    EPS = .0010_dp
    
    DO WHILE (TOUT .LT. 100.0_dp)
      CALL DDRIV1 (N, T, Y, F, TOUT, MSTATE, EPS, WORK, LENW, IERFLG)
      IF(MSTATE .GT. 2) STOP 
      WRITE(12,FMT='(4E17.8)') TOUT, (Y(i), i=1,N)
      TOUT = TOUT+dT
    END DO
!------------------------------------  
    END PROGRAM Sveifill


!------------------------------------
    SUBROUTINE F (N, T, Y, YDOT)
!
    USE Mod_Precision

    REAL(KIND=dp)  :: ALFA, T
    REAL(KIND=dp), DIMENSION(*)  :: Y, YDOT
    ALFA = Y(N+1)
    bom0 = Y(N+2)
    YDOT(1) = Y(2) 
    YDOT(2) = -SIN(Y(1))           ! ólínulegur  
!   YDOT(2) = -Y(1) - ALFA*Y(2)    ! Línulegur með deyfingu
!   YDOT(2) = -Y(1) - ALFA*Y(2) + 0.2_dp*SIN(0.7_dp*T)*EXP(-0.3_dp*T) ! Línulegur með deyfingu og örvunarlið
!------------------------------
    END SUBROUTINE F
