!
    PROGRAM Sveifill
!-----------------------------------------------
!

    USE Mod_Precision
   
    IMPLICIT NONE

    REAL(KIND=dp)  ::  EPS, T, TOUT, dT 
    INTEGER        ::  i, IERFLG, MSTATE
    
   
!   REAL(KIND=dp), PARAMETER    :: Om   = 0.1_dp
!   REAL(KIND=dp), PARAMETER    :: bom0 = 0.1_dp
    REAL(KIND=dp), PARAMETER    :: pi = 3.14159265358979324_dp
    INTEGER,       PARAMETER    :: N = 2          ! N is the number of equations
    INTEGER,       PARAMETER    :: LENW = N*N + 11*N + 300
   
   
    REAL(KIND=dp),  DIMENSION(LENW) ::   WORK
    REAL(KIND=dp),  DIMENSION(N+1)  ::   Y
    REAL(KIND=dp)                   ::   bom0
    
    REAL(KIND=dp), EXTERNAL  :: F
    
    OPEN(UNIT=12,FILE='YTout.dtx',STATUS='NEW')
                
    T  = 0.000010_dp     !Initial point
     dT = 0.001_dp
!    dT = 2.0_dp*pi/0.7_dp
                       
!   Y(1) =  1.0_dp      !Set initial conditions
!   Y(2) =  0.0_dp

    READ(5,*) Y(1), Y(2), bom0
                    
    Y(N+1) = bom0
 
    TOUT = T
    MSTATE = 1
    EPS = .00010_dp
    
    DO WHILE (TOUT .LT. 300.0_dp)
      CALL DDRIV1 (N, T, Y, F, TOUT, MSTATE, EPS, WORK, LENW, IERFLG)
      IF(MSTATE .GT. 2) STOP 
!     IF(TOUT .GT. 4000.0_dp ) WRITE(12,FMT='(4E17.8)') TOUT, (Y(i), i=1,N)
      WRITE(12,FMT='(4E17.8)') TOUT, (Y(i), i=1,N)
      TOUT = TOUT+dT
    END DO
    
    END PROGRAM Sveifill

    SUBROUTINE F (N, T, Y, YDOT)
!
    USE Mod_Precision

    REAL(KIND=dp)  :: bom0, T, Om, A
    REAL(KIND=dp), DIMENSION(*)  :: Y, YDOT
    bom0 = Y(N+1)
    
    YDOT(1) =   Y(2) 
    YDOT(2) =  -Y(1)*(Y(1)**2-1) - bom0*Y(2)

    END SUBROUTINE F

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
