set term post eps enhanced color solid 'Helvetica' 20
set output '09-01.eps'

set key left bottom Left

w   = 7.3e-5
g   = 9.82
la  = 65.0*pi/180.0
xdp = 200.0

# x er tíminn

# xp(x) = (w*g*x**3/3.0)*cos(la) - xdp*x
# yp(x) = -w*xdp*(x**2)*sin(la)
# zp(x) = -0.5*g*(x**2) + w*xdp*(x**2)*cos(la)

xp(x) = (w*g*x**3/3.0)*cos(la)
yp(x) = -w*xdp*(x**2)*sin(la)
zp(x) = w*xdp*(x**2)*cos(la)

set xr [0:2.0]
set xlabel 't (s)'
set ylabel 'Deviation (m)'

set xzeroaxis

plot xp(x) w l lw 2 title '{/Symbol D}x',\
     yp(x) w l lw 2 title '{/Symbol D}y',\
     zp(x) w l lw 2 title '{/Symbol D}z'

