#!/usr/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Version 4.6 patchlevel 5    last modified February 2014
#    	Build System: Linux x86_64
#    
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2014
#    	Thomas Williams, Colin Kelley and many others
#    
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
#    
#    	Type `load "all.dem"` to display a large number of examples.
#    	They are located at /usr/share/doc/packages/gnuplot/demo/*
#    
set terminal postscript landscape enhanced defaultplex \
   leveldefault color colortext \
   solid dashlength 1.0 linewidth 1.0 butt noclip \
   nobackground \
   palfuncparam 2000,0.003 \
   "Helvetica" 18  fontscale 1.0 
set output 'vt.ps'

set key inside right bottom vertical Left noreverse enhanced autotitles nobox

set xlabel "gt/v_t" 
set ylabel "v/v_t" 
set yr [0:1.4]

plot [0:4] (1-exp(-x)) w l lw 2 title 'f=kv',\
           tanh(x) w l lt 3 lw 2 title 'f=Dv^2',\
           x w l lt 2 lw 2 title 'f=0',\
           1.0 lt 7 lw 1 notitle 
#    EOF
