   PROGRAM Adal
!------------------------------------------------------------
! 
!  
!------------------------------------------------------------
!
   USE Mod_Precision         ! Module for setting double precision
   USE Mod_Init              ! Initial values
   USE Mod_Fields            ! Global variables 


   IMPLICIT NONE
!------- Local variables ------------------------------------
!
   INTEGER         :: i, Nband
   REAL(KIND=dp)   :: qa, eps, R, xka, Kinc, B, C, RE, AE, Ka0, Ep, Em

   REAL(KIND=dp),    EXTERNAL   :: Fallp, Fallm
!
!------- Úttak ----------------------------------------------
!
   OPEN(UNIT=12,FILE= 'Em.dtx' ,STATUS='NEW')

!  STATUS='NEW' the program will only run if these output files
!  do not exist
!------------------------------------------------------------

   beta  = 1.0_dp
   Nband = 1                       ! Númer borða    
   NKa   = 400                     ! Fjöldi Ka-punkta 
   Kinc  = 2.0_dp*pi/REAL(NKa,8)   ! Ka-skref 
   eps   = 0.0000001_dp            ! Nákvæmni   
   RE    = eps                     ! Afstæð nákvæmni 
   AE    = eps                     ! Algild nákvæmni  

   DO i = 1, NKa
     Ka  = i*Kinc-pi
     B     = REAL(Nband-1,8)*pi    ! Neðri mörk bils sem rótar er leitað á   
     C     = pi*REAL(Nband,8)      ! Efri mörk
     R     = (B+C)*0.5_dp
     Iflag = 0
     CALL DFZERO(Fallm,B,C,R,RE,AE,Iflag)   ! Rótarleitar undirforrit     
     Ka0  = B                               ! Rót 
     Em   = Ka0**2                          ! Orka
     WRITE(12,FMT='(E15.8,2X,E15.8,2X,E15.8,3X,I5)') Ka, Em, ka0, Iflag
   END DO


!------------------------------------------------------------
!
END PROGRAM Adal







