#!/usr/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Version 4.6 patchlevel 0    last modified 2012-03-04 
#    	Build System: Linux x86_64
#    
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2012
#    	Thomas Williams, Colin Kelley and many others
#    
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
#    
#    	Type `load "all.dem"` to display a large number of examples.
#    	They are located at /usr/share/doc/packages/gnuplot/demo/*
#    
 set terminal postscript landscape enhanced defaultplex \
   leveldefault color colortext \
   solid dashlength 1.0 linewidth 1.0 butt noclip \
   nobackground \
   palfuncparam 2000,0.003 \
   "Helvetica" 18  fontscale 1.0 
 set output 'C2-E.ps'

set xlabel "E/E_1" 
set xlabel  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set x2label "" 
set x2label  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set xrange [ * : * ] noreverse nowriteback
set x2range [ * : * ] noreverse nowriteback
set ylabel "|C|^2" 
set ylabel  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set y2label "" 
set y2label  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set yrange [ * : * ] noreverse nowriteback
set y2range [ * : * ] noreverse nowriteback
set zlabel "" 
set zlabel  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set zrange [ * : * ] noreverse nowriteback
set cblabel "" 
set cblabel  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set cbrange [ * : * ] noreverse nowriteback
set zero 1e-08

set locale "en_US.UTF-8"
set key right top
# ------------------------ Föll --------------------------------
I={0.0,1.0}  # þvereining i
# x=ka
# y=gamma
icot(x) = I/tan(x)
gp(x)  = (1.0+I*x)
gm(x)  = (1.0-I*x)
C(x,y) = (I*exp(-I*x)/(2*sin(x)))*(1+(gp(y)-icot(x))/(gm(y)+icot(x)))
#----------------------------------------------------------------
#
plot [0:16.0*pi**2][0:2.4] abs(C(sqrt(x),-0.1/sqrt(x)))**2 w l title '|C|^2, ({/Symbol a}/(aE_1))=0.1' lw 2,\
                        abs(C(sqrt(x),-1.0/sqrt(x)))**2 w l title '|C|^2, ({/Symbol a}/(aE_1))=1.0' lw 2,\
                        abs(C(sqrt(x),-2.0/sqrt(x)))**2 w l title '|C|^2, ({/Symbol a}/(aE_1))=2.0' lw 2,\
                        1.0 w l title '|B|^2' lt 4 lw 2
#    EOF
