set terminal postscript eps enhanced defaultplex \
   leveldefault color colortext \
   dashed dashlength 1.0 linewidth 1.0 butt \
   palfuncparam 2000,0.003 \
   "Helvetica" 22
set output 'Bessel_4.eps'

#1
set isosamples 80
set xlabel 'x' offset character 0, 0, 0
set ylabel 'y' offset character 0, 0, 0
set zlabel 'J_0(x^2+y^2)' offset character 5, 4, 0
#splot [-4:4][-4:4] besj0(x**2+y**2) w l

#2
#set ticslevel 0
#set hidden3d
#splot [-4:4][-4:4] besj0(x**2+y**2) w l

#3
#set ticslevel 0
#set pm3d 
#splot [-4:4][-4:4] besj0(x**2+y**2) w pm3d

#4
set nokey
set xtics -4,2,4
set ytics -4,2,2 offset character 0,-0.4,0
set ztics -0.5,0.5,1.0
set cbtics -0.5,0.5,1.0
set view 30,30
set pm3d at bs
set ticslevel 1.0
splot [-4:4][-4:4] besj0(x**2+y**2) w pm3d

#5
#set nokey
#set xtics -4,2,4
#set ytics -4,2,2 offset character 0,-0.4,0
#set ztics -0.5,0.5,1.0
#set cbtics -0.5,0.5,1.0
#set view 30,30
#set ticslevel 0
#set hidden3d
#set pm3d explicit at s
#splot [-4:4][-4:4] besj0(x**2+y**2) w l palette