set term post eps enhanced color solid 'Helvetica' 18
set output '3-V1.eps'

ga(p,q)        = pi*sqrt(p**2+q**2)
gz(z,p,q)      = ga(p,q)*z
C(p,q)         = 16.0/((p*q*pi**2)*(exp(ga(p,q))+1.0))
D(p,q)         = 16.0*exp(ga(p,q))/((p*q*pi**2)*(exp(ga(p,q))+1.0))
Vpq(x,y,z,n,m) = sin((2*n+1)*pi*x)*sin((2*m+1)*pi*y)\
                 *(C((2*n+1),(2*m+1))*exp(+gz(z,(2*n+1),(2*m+1)))+\
                   D((2*n+1),(2*m+1))*exp(-gz(z,(2*n+1),(2*m+1))))


set xlabel 'y/a'
set ylabel 'z/a'
set title 'V(0.5a,y,z)/V_0'
unset key

V(x,y,z,nmax,mmax) = sum[n=0:nmax] ( sum[m=0:mmax] Vpq(x,y,z,n,m))

set size square
set samples 100
set isosamples 100
set pm3d map
set zero 1e-20

splot [0:1.0][0:1.0] V(0.5,x,y,32,32) w pm3d
