set term post eps enhanced color solid 'Helvetica' 18
set output '3-yfirRho.eps'

ga(p,q)        = pi*sqrt(p**2+q**2)
gz(z,p,q)      = ga(p,q)*z
C(p,q)         = 16.0/((p*q*pi**2)*(exp(ga(p,q))+1.0))
D(p,q)         = 16.0*exp(ga(p,q))/((p*q*pi**2)*(exp(ga(p,q))+1.0))
rhopq(x,y,n,m) = sin((2*n+1)*pi*x)*sin((2*m+1)*pi*y)*ga((2*n+1),(2*m+1))\
                 *(C((2*n+1),(2*m+1))*exp(+gz(1.0,(2*n+1),(2*m+1)))-\
                   D((2*n+1),(2*m+1))*exp(-gz(1.0,(2*n+1),(2*m+1))))


set xlabel 'x/a'
set ylabel 'y/a'
set title '[a/({/Symbol e}_0V_0)]{/Symbol r}_s(x,y)'
unset key

rho(x,y,nmax,mmax) = sum[n=0:nmax] ( sum[m=0:mmax] rhopq(x,y,n,m))

set size square
set samples 100
set isosamples 100
set pm3d map
set zero 1e-20

splot [0:1.0][0:1.0] rho(x,y,32,32) w pm3d
