 
# wxt
#set terminal wxt size 350,262 enhanced font 'Verdana,10' persist
# png
#set terminal pngcairo size 350,262 enhanced font 'Verdana,10'
#set terminal pngcairo size 1400,1048 enhanced font 'Verdana,18'
set term post eps enhanced color solid 'Helvetica' 18
set output 'Sívaln-V.eps'

unset key
#set border 0
#unset tics
set xlabel 'x/a'
set ylabel 'y/a'
unset colorbox
set xrange [-2.5:2.5]
set yrange [-2.5:2.5]
# get an equal grid
set size ratio -1
set samples 200    # x-axis
set isosamples 200 # y-axis
#set palette defined ( \
#    1 '#fffcf6', \
#    2 '#fff7db', \
#    3 '#fff4c2', \
#    4 '#feecae', \
#    5 '#f8ca8c', \
#    6 '#f0a848', \
#    7 '#c07860', \
#    8 '#a86060', \
#    9 '#784860', \
#   10 '#604860')

set title 'V(x,y)'

# Fjarlægð frá miðu hnitakerfis
  R(x,y)   = sqrt(x*x+y*y)
phi(x,y)   = atan2(y,x)

# Mætti
Psii(x,y) =     (R(x,y))**3*sin(3*phi(x,y))
Psio(x,y) = (1.0/R(x,y))**3*sin(3*phi(x,y))

Psi(x,y)   = R(x,y)>1 ?  Psio(x,y) : Psii(x,y) 

set pm3d map
splot Psi(x,y) w pm3d






