 
# wxt
#set terminal wxt size 350,262 enhanced font 'Verdana,10' persist
# png
#set terminal pngcairo size 350,262 enhanced font 'Verdana,10'
#set terminal pngcairo size 1400,1048 enhanced font 'Verdana,18'
set term post eps enhanced color solid 'Helvetica' 18
set output 'Sívaln-vigur.eps'

unset key
#set border 0
#unset tics
set xlabel 'x/a'
set ylabel 'y/a'
unset colorbox
set xrange [-2:2]
set yrange [-2:2]
# get an equal grid
set size ratio -1
set samples 40    # x-axis
set isosamples 40 # y-axis
#set palette defined ( \
#    1 '#fffcf6', \
#    2 '#fff7db', \
#    3 '#fff4c2', \
#    4 '#feecae', \
#    5 '#f8ca8c', \
#    6 '#f0a848', \
#    7 '#c07860', \
#    8 '#a86060', \
#    9 '#784860', \
#   10 '#604860')

set title 'E(x,y)'

# Fjarlægð frá miðu hnitakerfis
  R(x,y)   = sqrt(x*x+y*y)
phi(x,y)   = atan2(y,x)

# Mætti
Psii(x,y) =     (R(x,y))**3*sin(3*phi(x,y))
Psio(x,y) = (1.0/R(x,y))**3*sin(3*phi(x,y))

Psi(x,y)   = R(x,y)>1 ?  Psio(x,y) : Psii(x,y) 


# Þættir E-sviðs
Eir(x,y) = -(R(x,y))**2*sin(3*phi(x,y))
Eif(x,y) = -(R(x,y))**2*cos(3*phi(x,y))

Eor(x,y) =  (1.0/R(x,y))**4*sin(3*phi(x,y))
Eof(x,y) = -(1.0/R(x,y))**4*cos(3*phi(x,y))

Ex(x,y) = R(x,y)>1 ?  Eor(x,y)*cos(phi(x,y)) - Eof(x,y)*sin(phi(x,y)) : Eir(x,y)*cos(phi(x,y)) - Eif(x,y)*sin(phi(x,y))
Ey(x,y) = R(x,y)>1 ?  Eor(x,y)*sin(phi(x,y)) + Eof(x,y)*cos(phi(x,y)) : Eir(x,y)*sin(phi(x,y)) + Eif(x,y)*cos(phi(x,y))


enorm(x,y) = sqrt(Ex(x,y)**2 + Ey(x,y)**2)
# vigurþættir
dx(x,y)    = scaling*Ex(x,y)/enorm(x,y) 
dy(x,y)    = scaling*Ey(x,y)/enorm(x,y)  

# Skölun
scaling = 0.08

#set xzeroaxis
#set yzeroaxis
plot '++' u ($1-dx($1,$2)/2.0):($2-dy($1,$2)/2.0):(dx($1,$2)):(dy($1,$2)):\
    (Psi($1,$2)) with vectors head size 0.04,20,60 filled lc palett,\
    +sqrt(1-x**2) w l lw 2 lt 2, -sqrt(1-x**2) w l lw 2 lt 2







