#!/usr/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Version 4.6 patchlevel 6    last modified September 2014
#    	Build System: Linux x86_64
#    
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2014
#    	Thomas Williams, Colin Kelley and many others
#    
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
#    
#    	Type `load "all.dem"` to display a large number of examples.
#    	They are located at /usr/share/doc/packages/gnuplot/demo/*
#    
set term post landscape enhanced color solid 'Helvetica' 18
set output 'SivalnV.ps'

set view 56, 330, 1, 1
set samples 200, 200
set isosamples 200, 200

set xtics border in scale 1,0.5 mirror norotate  offset character 0, 0, 0 autojustify
set xtics 0,1,4
set ytics border in scale 1,0.5 mirror norotate  offset character -1, 0, 0 autojustify
set ytics autofreq  norangelimit
set ztics border in scale 1,0.5 nomirror norotate  offset character 0, 0, 0 autojustify
set ztics -1,0.5,1
set nox2tics
set noy2tics
set cbtics border in scale 1,0.5 mirror norotate  offset character 0, 0, 0 autojustify
set cbtics -1,0.5,1

set xlabel "r/a" 
set xlabel  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set x2label "" 
set x2label  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set xrange [ * : * ] noreverse nowriteback
set x2range [ * : * ] noreverse nowriteback
set ylabel "{/Symbol f}" 
set ylabel  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set y2label "" 
set y2label  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set yrange [ * : * ] noreverse nowriteback
set y2range [ * : * ] noreverse nowriteback
set zlabel "V(r,{/Symbol f})(6{/Symbol e}_0)/({/Symbol r}_{s0}a)" 
set zlabel  offset character 5, 6, 0 font "" textcolor lt -1 norotate
set zrange [ * : * ] noreverse nowriteback

set locale "en_US.UTF-8"
set pm3d implicit at bs
set pm3d scansautomatic
set pm3d interpolate 1,1 flush begin noftriangles nohidden3d corners2color mean

Vo(x,y)=sin(3*y)/x**3
Vi(x,y)=sin(3*y)*x**3
V(x,y)= x>1 ? Vo(x,y) : Vi(x,y)


splot [0:4][0:2*pi] V(x,y) w pm3d
#    EOF
