set term post eps enhanced color solid 'Helvetica' 20
set output 'Psi-Psi0.eps'

set xtics border in scale 1,0.5 mirror norotate  autojustify
set xtics -2,1
set ytics border in scale 1,0.5 mirror norotate  autojustify
set ytics -2,1
set ztics border in scale 1,0.5 nomirror norotate  autojustify
set ztics -0.5,0.5
set cbtics -0.5,0.5
unset x2tics
unset y2tics

set xlabel "z/a" 
set xlabel  font "" textcolor lt -1 norotate
set x2label "" 
set x2label  font "" textcolor lt -1 norotate
set xrange [ * : * ] noreverse nowriteback
set x2range [ * : * ] noreverse nowriteback
set ylabel "x/a" 
set ylabel  font "" textcolor lt -1 rotate by -270
set y2label "" 
set y2label  font "" textcolor lt -1 rotate by -270
set yrange [ * : * ] noreverse nowriteback
set y2range [ * : * ] noreverse nowriteback
set zlabel "[{/Symbol y}(x,z)+J_0(z/a)]a/J_0" 
set zlabel  offset character 7, 6, 0 font "" textcolor lt -1 norotate
set zrange [ * : * ] noreverse nowriteback
set cblabel "" 
set cblabel  font "" textcolor lt -1 rotate by -270
set cbrange [ * : * ] noreverse nowriteback

set locale "en_US.UTF-8"
set pm3d implicit at bs
set pm3d scansautomatic
set pm3d interpolate 1,1 flush begin noftriangles noborder corners2color mean
set palette positive nops_allcF maxcolors 0 gamma 1.5 color model RGB 
set palette rgbformulae 7, 5, 15
set colorbox default
set colorbox vertical origin screen 0.9, 0.2, 0 size screen 0.05, 0.6, 0 front bdefault
set style boxplot candles range  1.50 outliers pt 7 separation 1 labels auto unsorted

r(x,z)     = sqrt(x*x+z*z)
#psi(x,z)  = r(x,z)>1 ? -(0.5*(1.0/r(x,z))**3+1.0)*x : 0.0
psi(x,z)   = r(x,z)>1 ? -(0.5*(1.0/r(x,z))**3+1.0)*x+x : 0.0

set samples 200
set isosamples 200
set size square

splot [-2:2][-2:2] psi(x,y) w pm3d 
#    EOF
