 
# wxt
#set terminal wxt size 350,262 enhanced font 'Verdana,10' persist
# png
#set terminal pngcairo size 350,262 enhanced font 'Verdana,10'
set terminal pngcairo size 1400,1048 enhanced font 'Verdana,18'
set output 'J.png'

unset key
#set border 0
#unset tics
set xlabel 'x/a'
set ylabel 'z/a'
unset colorbox
set xrange [-2:2]
set yrange [-2:2]
# get an equal grid
set size ratio -1
set samples 40    # x-axis
set isosamples 40 # y-axis
#set palette defined ( \
#    1 '#fffcf6', \
#    2 '#fff7db', \
#    3 '#fff4c2', \
#    4 '#feecae', \
#    5 '#f8ca8c', \
#    6 '#f0a848', \
#    7 '#c07860', \
#    8 '#a86060', \
#    9 '#784860', \
#   10 '#604860')

set title 'Vigursviðið J(x,z)/J_0'

# Fjarlægð frá miðu hnitakerfis
R(x,z)     = sqrt(x*x+z*z)

# Mætti
Psi(x,z)   = R(x,z)>1 ? -(0.5*(1.0/R(x,z))**3+1.0)*z : 0.0


# Þætti J-sviðs
Jx(x,z)   = -1.5*(1.0/R(x,z))**5*x*z
Jz(x,z)   = (0.5*((1.0/R(x,z))**3)*(1-3.0*(z/R(x,z))**2)+1.0)


enorm(x,z) = sqrt(Jx(x,z)**2 + Jz(x,z)**2)
# vigurþættir
dx(x,z)    = R(x,z)>1 ? scaling*Jx(x,z)/enorm(x,z) : 0.0
dz(x,z)    = R(x,z)>1 ? scaling*Jz(x,z)/enorm(x,z) : 0.0

# Skölun
scaling = 0.08

set xzeroaxis
set yzeroaxis
plot '++' u ($1-dx($1,$2)/2.0):($2-dz($1,$2)/2.0):(dx($1,$2)):(dz($1,$2)):\
    (Psi($1,$2)) with vectors head size 0.04,20,60 filled lc palett
