set term post eps enhance color solid 'Helvetica' 18
set output 'Phi.eps'


set xzeroaxis
set yzeroaxis

set xlabel 't/{/Symbol t}_L'
set ylabel '{/Symbol F}(t)/{/Symbol F}_0'
set key right bottom Left
set yr [-1.1:1.1]
set title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=L_0{/Symbol a}/R_0'
f(x,tLf) = erf(x*tLf)

plot [-8:8] f(x,1) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=1.0' lw 2,\
            f(x,2) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=2.0' lw 2,\
            f(x,4) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=4.0' lw 2,\
            f(x,0.5) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=0.5' lw 2,\
            f(x,0.25) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=0.25' lw 2
