set term post eps enhance color solid 'Helvetica' 18
set output 'RL.eps'


i(x,tLf) = -exp(-(x)+0.25*(1.0/tLf)**2)*(erf(x*tLf-0.5*(1.0/tLf))+1)

set xzeroaxis
set yzeroaxis

set xlabel 't/{/Symbol t}_L'
set ylabel 'i(t)L_0/{/Symbol F}_0'
set key left bottom Left
set yr [-1.5:0.1]
set title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=L_0{/Symbol a}/R_0'

plot [-8:8] i(x,1) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=1.0' lw 2,\
            i(x,2) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=2.0' lw 2,\
            i(x,4) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=4.0' lw 2,\
            i(x,0.5) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=0.5' lw 2,\
            i(x,0.25) w l title '{/Symbol t}_L/{/Symbol t}_{/Symbol F}=0.25' lw 2
