# set terminal png transparent nocrop enhanced size 450,320 font "arial,8" 
# set output 'param.8.png'
unset border

set parametric
set view 170, 20, 1, 1
set view  equal xyz

set samples 242, 122
set isosamples 242, 122
#set samples 400, 200
#set isosamples 400, 200

set ticslevel 0
unset xtics 
unset ytics 
unset ztics

set urange [ 0 : 6.2832 ] noreverse nowriteback
set vrange [ 0 : 3.14159] noreverse nowriteback
set xrange [ -1.00000 : 1.00000 ] noreverse nowriteback
set yrange [ -1.00000 : 1.00000 ] noreverse nowriteback
set zrange [ -1.00000 : 1.00000 ] noreverse nowriteback
set pm3d depthorder

#set palette functions gray, gray, gray
#set palette cubehelix start 0.5 cycles 3 saturation 1
#set palette model XYZ functions gray**0.35, gray**0.5, gray**0.8

set colorbox
xx(u, v) = sin(v) * cos(u)
yy(u, v) = sin(v) * sin(u)
zz(u, v) = cos(v)

#f(x,y) = exp(-x**2-y**2)
f(x,y)  = besj1(x**2+y**2)
g(x,y)  = f(x+2,y+2)+f(x-2,y-2)
rs(v)   = 2/(tan(v*0.5))
xs(u,v) = rs(v)*cos(u)
ys(u,v) = rs(v)*sin(u)
fk(u,v) = g(xs(u,v),ys(u,v))

#color(u,v) = exp(-(rs(v))**2)*cos(2*u)
 color(u,v) = fk(u,v)

## Last datafile plotted: "++"
splot "++" using (xx($1,$2)):(yy($1,$2)):(zz($1,$2)):(color($1,$2)) with pm3d notitle
