#!/usr/bin/gnuplot -persist
#
#    
#    	G N U P L O T
#    	Version 4.6 patchlevel 3    last modified 2013-04-12 
#    	Build System: Linux x86_64
#    
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2013
#    	Thomas Williams, Colin Kelley and many others
#    
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
#    
#    	Type `load "all.dem"` to display a large number of examples.
#    	They are located at /usr/share/doc/packages/gnuplot/demo/*
#    
set term post landscape enhanced color solid 'Helvetica' 18
set output 'series.ps'

set key right bottom Left

set xlabel "x/L" 
set xlabel  offset character 0, 0, 0 font "" textcolor lt -1 norotate

set ylabel "g(x,n_{max})" 
set ylabel  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270

set xzeroaxis
set samples 5000

a(n) = 1.0/n
f(x,n) = a(n)*sin(pi*n*x)
g(x,nmax) = sum[n=1:nmax] f(x,n)

plot [-1:1] g(x,4)   w l lw 2 title "n_{max}=4",\
            g(x,8)   w l lw 2 title "n_{max}=8",\
            g(x,128) w l lw 2 title "n_{max}=128"
#    EOF
